/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class FspCecState {
    private UnsignedInt16 mCecStateSummary;
    private UnsignedInt8 mCecPowerState;
    private UnsignedInt8 mCecNextPowerState;
    private UnsignedInt8 mCecRunState;
    private UnsignedInt8 mCecNextRunState;
    private UnsignedInt16 mMaxHypCommands;
    private static final String GET_CEC_STATE = "GET_CEC_STATE";
    private static final String GET_CEC_STATE_V3 = "GET_CEC_STATE_V3";
    private static final String CEC_STATE_SUMMARY = "CEC_STATE_SUMMARY";
    private static final String CEC_POWER_STATE = "CEC_POWER_STATE";
    private static final String CEC_NEXT_POWER_STATE = "CEC_NEXT_POWER_STATE";
    private static final String CEC_RUN_STATE = "CEC_RUN_STATE";
    private static final String CEC_NEXT_RUN_STATE = "CE_NEXT_RUN_STATE";
    private static final String MAX_HYP_COMMANDS = "MAX_HYP_COMMANDS";
    private static final String STATE = "STATE";

    FspCecState() {
    }

    FspCecState getCecStateCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(GET_CEC_STATE, null);
        if (hashtable == null) {
            return null;
        }
        this.mCecPowerState = (UnsignedInt8)hashtable.get(STATE);
        this.mMaxHypCommands = (UnsignedInt16)hashtable.get(MAX_HYP_COMMANDS);
        return this;
    }

    FspCecState getCecStateV3Cmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(GET_CEC_STATE_V3, null);
        if (hashtable == null) {
            return null;
        }
        this.mCecStateSummary = (UnsignedInt16)hashtable.get(CEC_STATE_SUMMARY);
        this.mCecPowerState = (UnsignedInt8)hashtable.get(CEC_POWER_STATE);
        this.mCecNextPowerState = (UnsignedInt8)hashtable.get(CEC_NEXT_POWER_STATE);
        this.mCecRunState = (UnsignedInt8)hashtable.get(CEC_RUN_STATE);
        this.mCecNextRunState = (UnsignedInt8)hashtable.get(CEC_NEXT_RUN_STATE);
        this.mMaxHypCommands = (UnsignedInt16)hashtable.get(MAX_HYP_COMMANDS);
        System.out.println("In getCecStateV3Cmd: " + this.toString());
        fSPCmdMgr.setPhypReady(this.mCecPowerState.intValue() == 1 && this.mCecRunState.intValue() == 15);
        return this;
    }

    public UnsignedInt16 getCecStateSummary() {
        return this.mCecStateSummary;
    }

    public UnsignedInt8 getCecPowerState() {
        return this.mCecPowerState;
    }

    public UnsignedInt8 getCecNextPowerState() {
        return this.mCecNextPowerState;
    }

    public UnsignedInt8 getCecNextRunState() {
        return this.mCecNextRunState;
    }

    public UnsignedInt8 getCecRunState() {
        return this.mCecRunState;
    }

    public UnsignedInt16 getMaxHypCommands() {
        return this.mMaxHypCommands;
    }

    public String toString() {
        String string = "mCecPowerState: " + this.mCecPowerState;
        string = string + ", mCecRunState: " + this.mCecRunState;
        string = string + ", mCecNextPowerState: " + this.mCecNextPowerState;
        string = string + ", mCecNextRunState: " + this.mCecNextRunState;
        string = string + ", mCecStateSummary: " + this.mCecStateSummary;
        string = string + ", mMaxHypCommands: " + this.mMaxHypCommands;
        return string;
    }
}

